<?php get_header(); ?>
	<div id="content" class="narrowcolumn">
	<?php if (have_posts()) : ?>
		<h2 class="pagetitle">Search Results</h2>
		<?php while (have_posts()) : the_post(); ?>
			<div class="post">
				<div class="postwrapper">
					<a href="<?php the_permalink() ?>" rel="bookmark" title="Continue reading the rest of this entry &#187;"><img src="<?php $key="thumbnail"; echo get_post_meta($post->ID, $key, true); ?>" alt="thumbnail" class="thumbnail" /></a>
					<h2 id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
					<div class="entry">
						<?php the_excerpt(); ?>
					</div>
				</div>
				<div class="postmetadata">
					<span class="thetime"><?php the_time('F jS, Y') ?></span>
					<span class="thecategory"><?php the_category(', ') ?></span>
					<?php edit_post_link('Edit', '<span class="editthispost">', '</span>'); ?>
					<span class="thecomments"><?php comments_popup_link('No Comments &#187;', '1 Comment &#187;', '% Comments &#187;'); ?></span>
					<div class="readmore">
						<a href="<?php the_permalink() ?>" rel="bookmark" title="Continue reading the rest of this entry &#187;">Read More</a>
					</div>
				</div>
			</div>
		<?php endwhile; ?>

			<div class="navigation">
				<div class="navleft"><?php next_posts_link('Older Entries') ?></div>
				<div class="navright"><?php previous_posts_link('Newer Entries') ?></div>
			</div>

	<?php else : ?>

		<h2 class="center">No posts found. Try a different search?</h2>
		<?php include (TEMPLATEPATH . '/searchform.php'); ?>

	<?php endif; ?>

	</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>